# this data is copied (and classified according to the arrangement in) 
# "Organum Mathematicum" (O.M.) - I am working on a second version of this file
# that arranges the data according to the tables in "Musurgia Universalis" (M.U.)
#
# Some additional data from M.U. has been inserted into these tables.

$cardsets = [
{
title => 'euripedeaea (class I fronts)',
recommendedModes => [1,2,3,4],
meter => '4/4',


# Note lengths indicate metrical beats per note.  You may randomly choose any one of these.
#
# A negative value on the first note indicates a rest.  Kircher only precedes
# phrases with rests, but never inserts them in the middle of phrases.
#
# A negative value on subsequent notes (which you'll see in class 3 and 4, below,
# which have more complex rhythms in the "florid style")
# indicates that the note is elided and does not get a discrete syllable.
# in both cases, the actual metric value is the absolute value.

notelengths => [[6,2,2,2,4,4],       # 5 measures
		[3,1,2,2,4,4],       # 4 measures
		[2,2,2,2,4,4],       # 4 measures
		[1,1,1,1,4,4],       # 3 measures
		[1.5,.5,1,1,2,2],    # 2 measures
		[-2,4,2,2,2,4,4],    # 5 measures
		[-1,2,1,1,1,2,4],    # 3 measures
		[4,2,4,2,4,4]        # 5 measures
		],

# These are for tripla (3/2) rhythm.  The metric values are not as notated, but
# have already been adjusted for modern notation, using the rules in Apel.
#
tripla => [    [4,2,4,2,6,6],
                [-2,2,2,4,2,6,6],
                [2,2,2,2,4,6]  ],
cards => [
{ 

	# This are the pitch values for phrases.  They are in groups of 4, corresponding
	# to the 4 vocal parts (C,A,T,B).
	# The upper voices (C,A,T) may be scrambled.
	#
	p => [[	[5,5,3,2,3,3],	     # class 1, card 1 front
		#[8,5,5,7,7,7],      # O.M.
		[8,7,5,7,7,7],       # M.U.
		[3,2,3,4,5,5],
		#[8,5,8,7,3,3]	     # O.M.
		[8,6,8,7,3,3]	     # M.U.
		],
	[	[5,5,5,5,5,5],
		[8,8,8,7,8,8],
		[3,3,3,2,3,3],
		[1,1,1,5,1,1]	],
	[	[8,2,3,6,4,4],
		[5,7,8,8,7,8],
		[3,1,8,4,2,3],
		[8,7,6,4,5,1]	],
	[	[8,2,3,2,1,7],
		[8,7,7,7,5,5],
		[5,5,5,4,3,2],
		[6,5,3,4,8,5]	],
	[	[3,2,3,4,5,5],
		[8,7,8,2,7,7],
		[5,5,5,2,3,3],
		[8,5,1,7,3,3]	],
	[	[3,4,5,4,2,3],
		[8,7,7,6,5,5],
		[5,4,3,8,7,8],
		[1,2,3,4,5,1]	]	]
}, # end of card
{ p => [[	[5,4,3,2,4,2],		# class 1, card 2 front
		[7,7,5,7,8,7],
		[3,2,3,5,8,5],
		[3,7,6,5,6,5]	],
	[	[3,3,3,3,2,2],
		[7,7,7,7,7,7],
		[5,5,5,5,4,4],
		[3,3,3,3,7,7]	],
	[	[7,6,7,3,2,2],
		[2,4,5,5,4,5],
		[7,8,5,8,6,7],
		[5,4,3,1,2,3]	],
	[	[3,2,3,5,4,5],
		[5,7,3,7,7,7],
		[3,4,8,3,2,8],
		[8,7,6,3,7,3]	],
	[	[3,2,3,5,8,3],
		[5,7,8,7,6,5],
		[3,4,8,7,4,7],
		[8,7,6,5,4,3]	],
	[	[3,2,3,5,2,3],
		[5,7,8,7,6,5],
		[3,4,8,3,4,7],
		[8,7,6,5,4,3]	]	]
},
{ p => [[	[5,5,4,3,2,3],		# class 1, card 3 front
		[7,7,7,5,7,7],
		[3,3,2,3,4,5],
		[3,3,7,8,7,3]	],
	[	[2,2,2,2,8,7],
		[7,7,7,7,5,5],
		[4,4,4,4,3,2],
		[7,7,7,7,8,5]	],
	[	[4,2,3,5,4,5],
		[5,7,8,7,7,7],
		[3,4,8,3,2,3],
		[8,7,6,3,7,3]	],
	[	[5,4,5,4,3,2],
		[7,7,7,7,8,7],
		[3,2,3,4,5,5],
		[3,7,3,2,1,7]	],
	[	[5,4,6,5,4,5],
		[7,2,3,2,8,7],
		[5,7,3,5,8,2],
		[3,2,1,7,6,5]	],
	[	[5,4,6,5,4,5],
		[7,2,3,2,8,7],
		[5,7,3,5,8,2],
		[3,2,1,7,6,5]	]	]
},
{ p => [[	[5,4,3,4,2,3],		# class 1, card 4 front
		[7,7,5,6,5,5],
		[3,2,3,1,7,1],
		[3,7,8,4,5,1]	],
	[	[5,5,4,3,2,3],
		[7,7,6,5,5,5],
		[3,3,1,1,7,1],
		[3,3,4,1,5,1]	],
	[	[7,7,6,8,7,8],
		[5,5,4,3,5,5],
		[3,3,8,8,2,3],
		[3,3,4,6,5,1]	],
	[	[8,7,6,8,7,8],
		[6,5,4,5,5,5],
		[3,3,1,3,2,3],
		[6,3,4,1,5,1]	],
	[	[8,8,2,3,2,3],
		[6,5,7,8,7,8],
		[1,1,4,5,5,5],
		[4,3,2,1,5,1]	],
	[	[5,5,4,3,2,3],
		[7,7,6,5,5,5],
		[3,3,1,1,7,1],
		[3,3,4,1,5,1]	]	]
}
] # end of cardlist
}, # end of cardset

{
title => 'anacreontica (class I backs)',
recommendedModes => [1,2,3,4],
meter => '4/4',
notelengths => [	[4,6,2,2,2,4,4],         # 6 measures
			[2,4,4,4,2,4,4],	 # 6 measures (MU Only)
			[2,1,1,1,1,2,4],         # 3 measures
			[2,1.5,.5,1.5,.5,2,4],   # 3 measures
			[2,4,2,2,2,4,4],         # 6 measures
			[4,3,1,1,1,2,4],         # 4 measures
			[-1,1,1,1,3,1,2,2],      # 4 measures
			[1,2,1,1,1,2,4],         # 3 measures
			[1,.5,.5,1,1,2,2]        # 2 measures
		],
tripla => [		[2,2,2,4,2,6,6],
			[6,4,2,4,2,6,6],         #
			[2,2,2,2,2,2,6],         # 3 measures  
			[2,4,2,4,2,4,6]		 # MU
	  ],
cards => [
{ p => [[	[5,5,5,4,3,2,3],		# class 1, card 1 back
		[7,7,8,6,5,5,5],
		[2,3,3,8,8,7,8],
		[5,3,8,4,8,5,8]	],
	[	[3,3,2,8,8,7,8],
		[8,8,7,6,6,5,5],
		[5,5,5,3,4,2,3],
		[8,8,5,6,4,5,1]	],
	[	[5,5,5,5,5,5,5],      # from M.U
		[8,8,8,8,7,8,8],
		[3,3,3,3,2,3,3],
		[8,8,8,8,5,1,1] ],
	[	[5,5,6,5,3,2,3],
		[7,7,8,8,8,7,8],
		[2,2,4,5,5,5,5],
		[5,5,4,3,1,5,1]	],
	[	[3,3,4,5,4,2,3],
		[8,8,7,7,8,5,5],
		[5,5,4,3,8,7,8],
		[1,1,2,3,4,5,1]	],
	[	[5,5,5,4,3,2,3],    # from M.U.
		[8,7,8,6,5,5,5],
		[3,2,3,8,8,7,8],
		[1,5,3,4,1,5,1] ],
	[	[3,4,5,4,3,2,3],
		[5,6,5,7,8,7,8],
		[8,8,8,2,5,5,5],
		[1,4,3,2,1,5,1]	],
	[	[3,3,2,8,6,5,5],   # from M.U.
		[5,5,5,3,4,2,3],
		[8,8,7,8,8,7,8],
		[1,1,5,6,4,5,1] ],
	[	[5,5,5,4,3,2,3],
		[7,7,8,7,5,5,5],
		[2,3,3,8,8,7,8],
		[5,3,1,4,1,5,1]	],
	[	[3,3,4,5,4,2,3],   # from M.U.
		[8,8,7,7,6,5,5],
		[5,5,4,3,8,7,8],
		[1,1,2,3,4,5,1] ] ]
}, # end of card
{ p => [[	[3,3,2,8,7,7,7],		# class 1, card 2 back
		[8,8,7,6,5,4,5],
		[5,5,4,3,3,2,3],
		[8,8,5,6,3,7,3]	],
	[	[5,5,4,3,2,2,2],
		[7,7,7,5,7,6,7],
		[3,3,2,3,5,4,5],
		[3,3,7,8,5,2,5]	],

	[	[3,3,3,3,3,4,4],
		[7,7,7,7,7,7,7],
		[5,5,5,5,5,2,2],
		[3,3,3,3,3,7,7] ],
		
	[	[3,3,2,8,7,6,5],
		[8,8,7,6,5,4,5],
		[5,5,5,3,3,8,3],
		[8,8,5,6,3,4,3]	],
	[	[5,5,4,4,3,2,2],
		[7,7,8,2,8,6,7],
		[2,2,8,5,5,4,5],
		[5,5,6,7,6,2,5]	],
	[	[2,3,2,8,7,6,7],
		[7,8,7,5,5,4,5],
		[5,5,4,3,2,2,2],
		[5,1,2,3,5,2,5]	],
	[	[3,3,2,8,7,6,7],
		[7,7,7,5,5,4,5],
		[5,5,4,3,2,2,2],
		[3,3,7,8,5,2,5] ],
	[	[5,5,4,3,2,4,2],
		[7,7,7,8,2,8,7],
		[3,3,4,5,5,8,5],
		[3,3,2,8,7,6,5]	],
	[	[5,5,4,3,3,2,3],
		[7,8,2,7,8,7,7],
		[5,5,6,5,4,4,5],
		[3,3,4,5,6,7,3] ] ]
},
{ p => [
	[	[5,5,4,3,2,4,2],  # m.u.      # class 1, card 3 back
		[7,7,7,8,2,8,7],
		[3,3,4,5,5,8,5],
		[3,3,2,1,7,6,5] ],
	[	[5,5,5,3,5,4,5],				
		[8,8,7,8,7,7,7],
		[3,3,2,8,3,2,3],
		[8,8,5,6,3,7,3]	],
	[	[2,2,2,2,2,8,7],  # m.u.
		[7,7,7,7,7,5,5],
		[4,4,4,4,4,3,2],
		[7,7,7,7,7,8,5] ],
	[	[5,5,4,3,2,8,7],
		[7,7,7,5,5,3,5],
		[3,3,2,8,7,8,2],
		[3,3,7,8,5,6,5]	],
	[	[5,5,4,3,3,2,3],
		[7,7,2,7,8,7,7],
		[5,5,6,5,4,4,5],
		[3,3,4,5,6,7,3]	],
	[	[3,6,5,3,6,5,4],
		[8,8,7,8,8,8,6],
		[5,4,2,8,4,3,4],
		[8,4,5,6,4,8,4]	],
	[	[3,4,3,8,8,8,8],
		[8,8,7,6,6,5,6],
		[5,6,5,3,4,3,4],
		[8,4,5,6,4,8,4] ],
	[	[5,5,5,4,3,2,3],
		[7,7,7,7,5,7,7],
		[3,3,3,2,3,4,5],
		[3,3,3,7,8,7,3]	],
	[	[5,5,5,3,3,2,3],
		[8,8,7,8,7,7,7],
		[3,3,2,1,5,4,5],
		[8,8,5,6,3,7,3]	],
	[	[3,3,2,6,7,6,5],	# m.u.
		[8,8,7,6,5,4,5],
		[5,5,5,3,3,8,3],
		[8,8,5,6,3,4,3] ]		]
},
{ p => [[	[8,8,8,2,3,2,3],	# class 1, card 4 back
		[6,6,5,7,8,7,8],
		[4,4,5,4,5,5,5],
		[4,4,3,2,1,5,1]	],
	[	[5,5,5,4,3,2,3],
		[7,7,7,6,5,5,5],
		[3,3,3,8,8,7,8],
		[3,3,3,4,1,5,1]	],
	[	[7,7,7,6,8,7,8],
		[5,5,5,4,3,5,5],
		[3,3,3,8,8,2,3],
		[3,3,3,4,6,5,1]	],
	[	[8,8,8,2,3,2,3],        # m.u.
		[6,6,5,7,8,7,8],
		[8,8,3,4,5,5,5],
		[4,4,3,2,1,5,1] ],
	[	[5,5,4,4,3,2,3],
		[7,7,6,6,5,5,5],
		[2,2,2,8,8,7,8],
		[5,5,2,4,1,5,1]	],
	[	[3,2,8,7,6,5,5],
		[8,7,6,5,4,2,3],
		[5,5,3,3,8,7,8],
		[8,6,7,3,4,5,1]	],
	[	[3,2,8,6,8,7,8],      # m.u.
		[8,7,5,4,3,5,5],
		[5,4,3,8,8,2,3],
		[1,2,3,4,6,5,1] ],
	[	[8,3,4,5,4,2,3],      # m.u.
		[6,8,7,7,6,5,5],
		[4,5,4,3,8,7,8],
		[4,1,2,3,4,5,1] ],
	[	[8,8,8,2,3,2,3],      # m.u.
		[6,6,5,7,8,7,8],
		[8,8,3,4,5,5,5],
		[4,4,3,2,1,5,1] ],
	[	[3,4,5,4,3,4,3],
		[8,8,8,8,8,8,8],
		[5,6,5,6,5,6,5],
		[1,4,3,4,1,4,1]	]	]
}
] # end of cardlist
}, # end of cardset

{
title => 'sapphica (class 2 fronts)',
recommendedModes => [1,2,3,4],
meter => '4/4',
notelengths => [
               [4,2,2,2,2,6,2,2,2,4,4],
               [4,2,2,4,2,4,2,2,2,4,4],
               [4,1,1,2,1,.5,.5,1,1,2,4],
               [2,1,1,2,2,1.5,.5,1,1,4,4],
               [1,.5,.5,1,1,2,2,1,1,2,4],
               [4,2,2,2,2,4,2,4,2,4,4],
               ],
tripla =>      [
		[2,2,2,4,2,4,2,4,2,6,6],
		[2,2,2,4,2,2,2,2,2,4,6],
		[4,2,2,2,2,3,1,2,2,4,6],
		],
cards => [
{ p => [[	[3,3,2,8,7,6,8,8,8,7,8],	# class 2, card 1 front
		[8,8,7,6,5,4,5,6,4,5,5],
		[5,5,5,3,3,8,3,4,8,2,3],
		[8,8,5,6,3,4,8,4,6,5,1]	],
	[	[2,3,3,2,3,3,2,4,5,4,5],
		[7,8,8,7,8,8,2,8,7,6,7],
		[5,5,5,5,5,5,5,8,2,2,2],
		[5,3,1,5,1,8,7,8,5,2,5]	],
	[	[7,8,8,7,8,8,2,3,6,5,5],
		[5,5,5,5,5,5,5,8,8,7,8],
		[2,2,2,2,3,3,2,1,4,2,3],
		[5,3,1,5,1,8,7,6,4,5,1]	],
	[	[3,3,2,3,2,3,2,4,6,5,5],
		[8,8,7,8,7,8,2,8,8,7,8],
		[5,5,5,5,5,5,5,1,4,2,3],
		[1,1,5,1,5,8,7,6,3,5,1]	],
	[	[8,7,8,2,3,3,7,7,2,8,7],
		[5,5,6,7,7,6,5,5,7,5,5],
		[3,2,3,4,5,4,2,3,4,3,2],
		[1,5,8,7,3,4,5,3,7,1,5]	],
	[	[8,7,8,6,8,7,3,8,3,2,3],
		[5,5,5,4,5,5,5,6,5,5,5],
		[3,2,3,1,3,2,8,8,8,7,8],
		[1,5,3,4,1,5,3,4,1,5,1]	]	]
}, # end of card
{ p => [[	[8,8,7,8,8,2,2,8,8,6,7],				# class 2, card 2 front
		[5,5,5,5,6,7,7,5,5,4,5],
		[3,3,2,3,3,4,4,3,3,2,2],
		[1,1,5,1,1,7,7,1,1,2,5]	],
	[	[5,5,5,3,5,4,3,3,5,4,5],
		[7,7,7,8,7,7,7,8,7,7,7],
		[3,3,3,8,3,2,5,3,3,2,3],
		[3,3,3,6,3,7,5,6,3,7,3]	],
	[	[3,3,2,4,3,4,4,3,3,2,2],
		[8,8,7,8,8,2,2,8,8,6,7],
		[5,5,5,6,5,2,2,5,5,4,5],
		[8,8,8,4,8,7,7,8,8,2,5]	],
	[	[7,7,7,8,2,8,7,6,8,6,7],
		[5,5,4,5,7,5,5,4,5,4,5],
		[3,3,4,3,4,3,2,2,3,2,2],
		[3,3,2,1,7,2,5,2,1,2,5]	],
	[	[5,5,5,4,3,2,3,8,3,2,3],
		[7,7,7,7,6,2,7,6,7,6,7],
		[3,3,3,2,3,4,5,3,7,4,5],
		[3,3,3,7,8,7,3,6,5,4,3]	],
	[	[3,4,5,4,2,3,4,5,4,4,5],
		[8,8,7,8,7,8,2,7,8,7,7],
		[5,1,3,6,5,5,2,3,3,2,3],
		[8,6,3,4,5,8,7,5,6,7,3]	]	]
},
{ p => [[	[2,3,3,2,3,4,2,4,6,5,5],				# class 2, card 3 front
		[7,8,8,7,8,8,2,8,8,7,8],
		[5,5,5,5,5,5,5,1,4,2,3],
		[5,3,1,5,1,8,7,6,4,5,1]	],
	[	[3,3,3,4,5,1,2,8,8,7,8],
		[8,8,8,8,7,6,7,5,5,5,5],
		[5,5,5,1,2,4,4,3,3,2,3],
		[1,1,1,6,5,4,2,3,1,5,1]	],
	[	[3,3,3,8,7,6,8,7,8,7,8],
		[7,7,7,6,5,4,5,5,4,5,5],
		[5,5,5,3,3,1,3,2,1,2,3],
		[3,3,3,6,3,4,1,5,6,5,1]	],
	[	[3,2,8,7,3,2,8,7,8,7,8],
		[7,7,5,5,7,6,6,5,4,5,5],
		[5,4,3,2,5,4,4,2,1,2,3],
		[8,7,8,5,3,4,4,5,6,4,1]	],
	[	[2,4,3,4,5,3,2,8,8,7,8],
		[7,8,7,8,8,8,7,5,6,5,5],
		[4,4,5,6,5,5,4,3,2,2,3],
		[7,6,5,4,3,1,2,3,4,5,1]	],
	[	[2,3,2,3,3,2,5,4,3,2,3],
		[7,7,7,7,7,7,7,6,5,5,5],
		[5,5,4,5,5,4,3,8,8,7,8],
		[3,3,7,3,3,7,3,4,1,5,1]	]	]
},
{ p => [[	[3,2,4,5,5],				# class 2, card 4 front (ADONIC)
		[8,2,8,7,8],
		[5,5,1,2,3],
		[8,7,6,5,1]	],
	[	[8,8,8,7,5],
		[5,5,6,5,5],
		[3,3,4,2,3],
		[8,8,4,8,1]	],
	[	[8,8,3,2,3],
		[6,6,8,7,8],
		[4,4,5,5,5],
		[4,4,1,5,1]	],
	[	[7,8,8,7,8],
		[5,5,5,5,5],
		[2,3,3,2,3],
		[5,3,1,5,1]	],
	[	[5,3,6,5,5],
		[7,8,8,7,8],
		[3,1,4,2,3],
		[3,6,4,5,1]	],
	[	[6,8,8,7,8],
		[4,5,5,5,5],
		[8,2,2,3,2],
		[4,3,3,5,1]	]	],
  notelengths=> [  # adonic verse override for notelengths
  		[3,.5,.5,4,4],
  		[6,1,1,4,4],
  		[2,1,1,4,4],
  		[-2,4,2,4,4,4],
  		[-1,2,.5,.5,4,4],
  		[3,1,4,4,4],
  		[1,.5,.5,1,1]
  ],
  tripla => [      # adonic verse ovveride for tripla
      		[3,1,2,4,2],
      		[2,2,2,4,2]
           ],
}
] # end of cardlist
}, # end of cardset
{
title => 'archilochica (class II backs)', 
recommendedModes => [5,6,8],
meter => '4/4',
notelengths => [	[4,2,2,2,2,3,1,4],       # all cards in this set share this data
			[2,1,1,1,1,1.5,.5,4],
			[2,4,2,6,2,6,2,4],
			[1,.5,.5,1,1,1.5,.5,2],
			[1,2,1,1,1,1.5,.5,4],
			[-2,2,3,1,2,2,3,1,4],     # includes a leading rest
			[-1,1,1,1,3,1,3,1,4],     # includes a leading rest
			[2,4,2,1,1,1.5,.5,4],
			],
tripla => [		[2,2,2,4,2,4,2,6],
			[4,2,2,2,2,4,2,6],
			[4,2,2,2,2,2,2,2]
          ],
cards => [
# class 2, card 1 back
{ p => [[
	      # [5,5,5,4,3,2,2,1],	# ORIGINAL	
		[5,5,5,4,3,2,2,3],	# correction from duplicate Page 831 of "Organum"	
	      # [8,2,8,8,8,7,7,8],	# ORIGINAL
		[8,7,8,8,8,7,7,8],	# correction from page 831
		[3,2,3,6,5,5,5,5],
		[8,5,3,4,1,5,5,1]	],
	[	[3,2,4,3,3,2,2,3],
		[8,7,2,8,8,7,7,8],
		[5,5,6,5,5,5,5,5],
		[1,5,2,3,1,5,5,1]	],
	[	[3,3,2,8,8,7,7,8],
		[8,8,6,5,6,5,5,5],
		[5,5,4,3,2,2,2,3],
		[1,1,2,3,4,5,5,1]	],
	[	[3,8,8,2,3,2,2,3],	# additional strophe from page 831
		[5,6,5,6,8,7,7,8],
		[1,1,1,4,5,5,5,5],
		[1,4,3,2,1,5,5,1]	],
	[	[8,8,8,8,3,2,2,3],
		[5,6,5,6,5,5,5,5],
		[3,3,3,8,8,7,7,8],
		[8,6,3,4,1,5,5,1]	],
	[	[3,2,5,4,3,2,2,3], 	# additional strophe from page 831
		[8,7,8,8,8,7,7,8],
		[5,5,5,6,5,5,5,5],
		[1,5,3,4,1,5,5,1]	],
	[	[3,8,8,2,3,2,2,3], 	# additional strophe from page 831
		[5,6,5,6,8,7,7,8],
		[8,8,8,4,5,5,5,5],
		[1,4,3,2,1,5,5,1]	],
	[	[3,4,3,8,4,3,3,4],
		[8,8,7,6,8,8,8,8],
		[5,6,5,3,6,5,5,6],
		[8,4,5,6,4,1,1,4]	],
	[	[3,2,4,3,3,2,2,3],
		[8,7,2,8,8,7,7,8],
		[5,5,6,5,5,5,5,5],
		[1,5,2,3,1,5,5,1]	],
	[	[3,3,5,4,3,2,2,3],	# additional strophe from page 831
		[8,8,8,8,8,7,7,8],
		[5,6,5,6,5,5,5,5],
		[8,6,3,4,1,5,5,1]	]	]
}, # end of card
{ p => [[	[3,4,3,1,4,3,3,4],				# class 2, card 2 back
		[8,8,7,6,8,8,8,8],
		[5,6,5,3,6,5,5,6],
		[8,4,5,6,4,1,1,4]	],
	[	[3,3,2,3,5,5,4,5],
		[8,8,7,8,2,8,8,2],
		[5,5,5,5,5,6,6,7],
		[8,8,5,8,7,6,6,5]	],
	[	[5,5,5,8,7,6,6,7],
		[8,8,5,6,2,2,2,2],
		[3,3,2,3,5,4,4,5],
		[8,8,7,6,5,2,2,5]	],
	[	[5,5,4,3,2,2,2,2],	# additional strophe from page 831
		[2,3,2,8,7,6,6,7],
		[7,8,6,5,5,4,4,5],
		[5,1,2,3,5,2,2,5]	],
	[	[3,3,2,2,8,2,2,2],
		[8,8,7,6,5,6,6,7],
		[5,5,5,4,5,4,4,5],
		[1,1,5,2,3,2,2,5]	],
	[	[5,6,5,4,6,5,5,6],	# additional strophe from page 831
		[8,8,7,8,8,8,8,8],
		[3,4,2,8,4,3,3,4],
		[8,4,5,6,4,1,1,4]	],
	[	[8,7,8,7,3,2,2,3],	# additional strophe from page 831
		[5,5,3,5,5,5,5,5],
		[3,2,1,2,1,7,7,8],
		[8,5,6,5,1,5,5,1]	],
	[	[3,2,4,3,3,2,2,3],
		[8,7,2,8,8,7,7,8],
		[5,5,6,5,5,5,5,5],
		[1,5,2,3,1,5,5,1]	],
	[	[3,3,2,3,5,5,4,5],
		[8,8,7,8,2,8,8,2],
		[5,5,5,5,5,6,6,7],
		[8,8,5,8,7,6,6,5]	],
	[	[3,2,4,3,3,2,2,3],	# additional strophe from page 831 (dupe of #8)
		[8,7,2,8,8,7,7,8],
		[5,5,6,5,5,5,5,5],
		[1,5,2,3,1,5,5,1]	]	]
},
{ p => [[	[3,2,3,4,3,2,2,3],	# class 2, card 3 back
		[8,7,8,2,8,7,7,8],
		[5,5,5,6,5,5,5,5],
		[1,5,3,2,3,5,5,1]	],
	[	[3,2,2,2,1,2,2,2],
		[8,7,7,6,5,6,6,7],
		[5,5,5,4,5,4,4,5],
		[5,5,5,2,3,2,2,5]	],
	[	[5,5,4,4,3,2,2,2],
		[8,7,8,2,8,6,6,7],
		[3,2,6,5,5,4,4,5],
		[2,5,6,7,8,2,2,5]	],
	[	[3,2,8,5,4,3,3,3],	# additional strophe from page 831
		[8,7,6,7,2,7,7,8],
		[5,5,3,3,6,5,5,6],
		[8,5,6,3,2,3,3,6]	],
	[	[1,1,2,4,3,4,4,3],
		[5,5,5,6,7,8,8,8],
		[3,3,2,8,5,6,6,5],
		[8,8,7,6,5,4,4,1]	],
	[	[2,4,3,2,2,2,2,2],	# additional strophe from page 831
		[7,2,8,6,7,6,6,7],
		[5,6,5,6,5,4,4,5],
		[5,2,3,4,5,2,2,5]	],
	[	[5,6,5,4,6,5,5,6],	# additional strophe from page 831
		[8,8,7,8,8,8,8,8],
		[3,4,2,8,4,3,3,4],
		[8,4,5,6,4,1,1,4]	],
	[	[3,8,8,2,3,2,2,3],
		[5,6,5,6,8,7,7,8],
		[8,8,8,4,5,5,5,5],
		[1,4,3,2,1,5,5,1]	],
	[	[3,5,4,4,3,2,2,2],
		[7,2,8,2,8,6,6,7],
		[5,7,6,5,5,4,4,5],
		[8,5,6,7,8,2,2,5]	],
	[	[3,3,2,2,8,2,2,2],	# additional strophe from page 831
		[8,8,7,6,5,6,6,7],
		[5,5,5,4,5,4,4,5],
		[1,1,5,2,3,2,2,5]	]	]
},
{ p => [[	[5,4,4,3,2,2,2,3],				# class 2, card 4 back
		[8,8,2,8,8,7,7,8],
		[3,6,6,5,6,5,5,5],
		[1,4,2,3,4,5,5,1]	],
	[	[8,8,4,3,3,2,2,3],
		[5,6,2,8,8,7,7,8],
		[3,4,6,5,5,5,5,5],
		[1,4,2,3,1,5,5,1]	],
	[	[3,2,8,8,4,5,5,5],
		[8,6,5,6,6,7,7,8],
		[5,4,3,8,8,2,2,3],
		[1,2,3,4,6,5,5,1]	],
	[	[4,3,2,8,8,7,7,8],	# additional strophe from page 831
		[8,8,6,5,6,5,5,5],
		[6,5,4,3,2,2,2,3],
		[4,1,2,3,4,5,5,1]	],
	[	[3,2,8,8,8,7,7,8],
		[8,6,5,6,3,5,5,5],
		[5,4,3,8,8,2,2,3],
		[1,2,3,4,6,5,5,1]	],
	[	[3,2,8,8,8,7,7,8],	# additional strophe from page 831
		[8,7,6,5,6,5,5,5],
		[5,5,3,3,2,2,2,3],
		[1,5,6,3,4,5,5,1]	],
	[	[3,2,8,8,4,5,5,5],	# additional strophe from page 831
		[8,6,5,6,6,7,7,8],
		[5,4,3,2,8,2,2,3],
		[1,2,3,4,6,5,5,1]	],
	[	[5,5,4,3,2,2,2,3],
		[3,3,2,8,8,7,7,8],
		[8,8,6,5,6,5,5,5],
		[1,1,2,3,4,5,5,1]	],
	[	
		# [3,1,8,8,8,7,7,8],    # O.M.
		[3,2,8,8,8,7,7,8],      # correction from M.U. and page 831
		[8,6,5,6,3,5,5,5],
		[5,4,3,8,8,2,2,3],
		[1,2,3,4,6,5,5,1]	],
	[	[5,6,5,4,3,2,2,3],	# additional strophe from page 831
		[8,8,8,8,8,7,7,8],
		[3,4,5,6,5,5,5,5],
		[1,4,3,4,1,5,5,1]	]	]
}
] # end of cardlist
}, # end of cardset

# Class 3 and 4 are "florid style" - meaning 5th species counterpoint.
# In these tables, each melodic line gets its own rhythmic values,
# And some notes are elided, since each part may have a different number of
# of notes.
{
title => 'euripedean stylo (class III)',
recommendedModes => [1,2,3,4],
meter => '4/4',
cards => [
{ p => [[	[2,4,3,2,1,5,1,7,6,7],		# class 3, card 1
		[7,6,5,4,3,2,8,2],
		[2,2,7,7,5,5],
		[5,2,3,7,1,5]	],
	[	[7,3,3,2,7,1,7,1],
		[5,5,6,6,5,5],
		[2,8,8,4,4,3,2,3],
		[5,3,4,4,5,1] 	],
	[	[5,7,7,2,8,7,6,7],
		[3,4,5,7,5,5],
		[8,2,3,4,3,2,1,2],
		[1,7,3,7,1,5]	],
	[	[8,8,8,2,2,1,7,1,7],
		[5,5,5,5,5,5],
		[3,3,3,2,3,2],
		[8,8,8,7,8,5]	],
	[	[6,6,7,1,1,7,1],
		[4,4,4,5,5,5],
		[8,8,2,3,2,3],
		[4,4,2,1,5,1]	],
	[	[7,1,2,3,2,3],
		[5,5,7,1,1,7,1],
		[2,3,4,5,5,5],
		[5,3,2,1,5,1]	],
	[	[5,4,3,3,2,1,1,2,3,4,4,4,3,2,1],  # from M.U.
		[5,6,7,1,5,4,5,6,7,6,5,3],
		[8,2,3,4,8,7,8,2,8,7,8,8,7,8],
		[8,7,6,6,6,5,4,5,5,1] ],
	[	[4,3,2,1,7,1,7,6,7,1],  # from M.U.
		[8,7,6,5,6,5,5,5],
		[5,4,3,2,2,4,3,2,3],
		[5,4,3,2,1,4,4,5,1,5,1] ],
	[	[3,2,1,7,1,7,6,7,1],  # from M.U.
		[7,6,5,4,5,5],
		[5,4,2,1,2,3,2,1,2,3],
		[3,4,5,6,5,1] ],
	[	[4,4,3,3,2,3],  # from M.U.
		[1,1,1,1,1,7,6,7,1],
		[6,6,5,5,5,5],
		[4,4,1,1,5,1] ]
		],
   r => [[	[6,2,2,2,1,1,4,1,1,4],
		[6,2,2,2,6,1,1,4],
		[6,2,2,2,8,4],
		[6,2,2,2,8,4]	],
	[	[6,2,2,2,2,4,2,4],
		[6,2,2,2,8,4],
		[6,2,2,2,2,2,4,4],
		[6,2,2,2,8,4]	],
	[	[6,2,2,2,3,.5,.5,4],
		[6,2,2,2,4,4],
		[6,2,2,2,3,.5,.5,4],
		[6,2,2,2,4,4]	],
	[	[6,2,4,4,2,1,1,4,4],
		[6,2,4,4,8,4],
		[6,2,4,4,8,4],
		[6,2,4,4,8,4]	],
	[	[6,2,2,2,2,2,4],
		[6,2,2,2,4,4],
		[6,2,2,2,4,4],
		[6,2,2,2,4,4]	],
	[	[3,1,2,2,4,4],
		[2,2,2,2,2,2,4],
		[2,2,2,2,4,4],
		[2,2,2,2,4,4]	],
	[	[6,2,2,2,4,2,2,3,1,2,2,2,2,4,4],  # from M.U.  CHECK THIS ONE!!!
		[-2,2,3,1,2,2,3,1,4,4,4,8,4],
		[-2,2,3,1,2,2,4,2,1,1,2,2,2,2,4],
		[-4,-4,6,2,2,2,2,2,4,4,4,4] ],
	[	[-4,-2,1,1,1,1,1,2,.5,.5,2,4],  # from M.U.
		[-4,1,1,1,1,2,2,4,4],
		[-2,1,1,1,1,2,3,1,4,4],
		[1,1,1,1,2,2,2,1,1,4,4] ],
	[	[6,1,1,2,3,.5,.5,2,4],  # from M.U.
		[6,2,3,1,4,4],
		[6,2,2,1,1,1,.5,.5,2,4],
		[6,2,2,2,4,4] ],
	[	[6,2,6,2,4,4],  # from M.U.
		[6,2,6,2,1,.5,.5,2,4],
		[6,2,6,2,4,4],
		[6,2,6,2,4,4] ]
		]
}, # end of card
{ p => [[	[3,2,1,7,6,5,5],		# class 3, card 2
		[1,7,6,5,4,1,4,3,2,3],
		[5,5,3,3,8,8],
		[1,5,6,3,4,1]	],
	[	[8,2,3,3,4,7],
		[5,5,1,7,6,5],
		[3,2,8,3,3,2,3],
		[8,7,6,5,4,3] 	],
	[	[5,5,5,4,3,2,8,2],
		[7,7,2,2,2,1,7,1,7],
		[2,5,5,5,5,5],
		[5,5,7,7,8,5]	],
	[	[8,2,3,5,4,5],
		[5,5,8,7,7,7],
		[3,2,8,3,3,2,8,2,3],
		[8,7,6,3,7,3]	],
	[	[8,2,3,3,2,2,2,2],
		[5,1,6,7,6,7],
		[3,4,5,5,4,5,5,4,5],
		[8,8,8,7,2,5]	],
	[	[8,8,8,7,6,7],
		[5,5,6,5,5,4,5],
		[3,3,2,2,2,2],
		[8,8,4,5,2,5]	],
	[	[2,3,2,8,2,8,8,7,6,7],  # from M.U.
		[7,1,5,6,4,5,4,5],
		[5,4,4,3,2,2],
		[5,6,7,8,2,2,5] ],
	[	[3,3,4,5,6,5],  # from M.U.
		[5,6,7,8,7,8,8,8,8],
		[3,2,8,2,3,4,5,6,6,5,5,5,4,3,4,3],
		[8,7,6,5,4,3,4,1] ],
	[	[8,3,2,8,4,3,2,5,4,3,3,4,3,3,2,1,2,3],  # from M.U.
		[7,1,7,6,1,7,7,1,7,6,5],
		[3,4,3,2,5,4,3,2,1,2,3,1,2,3,4,5],
		[5,6,5,4,7,6,5,8,7,6,6,6,5,4,3] ],
	[	[3,2,2,2,2,2],  # from M.U.
		[1,7,6,7,6,7],
		[5,5,4,5,5,4,5],
		[1,2,3,4,5,6,7,8,2,2,7,8,2,5] ]
		],
   r => [[	[6,2,2,2,4,4,4],
		[6,2,2,2,1,1,4,1,1,4],
		[6,2,2,2,4,8],
		[6,2,2,2,4,8]	],
	[	[6,2,2,2,4,4],
		[6,2,2,2,4,4],
		[6,2,2,2,2,2,4],
		[6,2,2,2,4,4]	],
	[	[6,2,2,2,6,1,1,4],
		[6,2,2,2,2,1,1,4,4],
		[6,2,2,2,8,4],
		[6,2,2,2,8,4]	],
	[	[2,2,2,2,4,4],
		[2,2,2,2,4,4],
		[2,2,2,2,1,.5,.5,2,4],
		[2,2,2,2,4,4]	],
	[	[3,1,2,2,2,2,4,4],
		[6,2,2,2,4,4],
		[3,1,2,2,2,2,2,2,4],
		[6,2,2,2,4,4]	],
	[	[3,1,2,2,4,4],
		[3,1,2,2,2,2,4],
		[3,1,2,2,4,4],
		[3,1,2,2,4,4]	],
	[	[4,3,.5,.5,2,2,2,2,4,4],  # from M.U.
		[6,2,3,1,2,4,2,4],
		[6,2,2,2,8,4],
		[6,2,2,2,4,4,4] ],
	[	[6,2,4,4,8,4],  # from M.U.
		[2,1,1,2,2,4,4,8,4],
		[3,1,1,1,1,.5,.5,2,2,2,2,2,1,1,4,4],
		[3,1,2,2,4,4,8,4] ],
	[	[2,3,1,2,3,1,2,3,1,4,2,2,2,2,1,1,4,4],  # from M.U.
		[-2,2,3,1,1,1,4,2,8,4,8,4],
		[-4,2,3,1,2,3,1,3,1,1,1,1,1,2,2,8,4],
		[-2,2,3,1,2,3,1,2,3,1,2,2,2,2,8,4] ],
	[	[4,4,2,2,4,4],  # from M.U.
		[4,4,2,2,4,4],
		[4,4,2,2,2,2,4],  # modified this from printed table (note mismatch)
		[1,1,1,1,1,1,1,1,1,1,1,1,4,4] ]
		]
},
{ p => [[	[1,2,3,4,5,5,4,5],				# class 3, card 3
		[5,4,5,6,7,6,7],
		[3,2,8,2,2,2],
		[8,7,6,5,2,5]	],
	[	[5,5,6,5,5,4,5],
		[8,8,8,7,8,7],
		[3,3,4,3,2,3,2,8,2],
		[8,8,4,5,6,5]	],
	[	[7,2,1,1,1,7,6,7],
		[5,7,5,6,4,5,5,4,5],
		[3,4,3,3,2,2],
		[3,7,1,1,2,5]	],
	[	[3,3,3,3,3,2,3],
		[7,7,1,7,7,7],
		[5,5,3,5,4,5],
		[3,4,5,5,6,5,7,3]	],
	[	[3,4,6,5,5,4,5],
		[7,7,1,2,1,7],
		[5,4,3,2,3,2,8,2],
		[3,2,8,7,6,5]	],
	[	[5,5,3,5,4,5],
		[1,7,1,7,7,7],
		[3,2,8,3,3,2,3],
		[8,5,6,3,7,3]	]	],
   r => [[	[4,3,1,2,2,2,2,4],
		[4,2,2,2,2,4,4],
		[4,4,2,2,4,4],
		[6,2,2,2,4,4]	],
	[	[3,1,2,2,2,2,4],
		[3,1,2,2,4,4],
		[3,1,1,1,1,.5,.5,4,4],
		[3,1,2,2,4,4]	],
	[	[6,2,2,2,2,2,4,4],
		[6,2,2,2,2,2,2,2,4],
		[6,2,2,2,8,4],
		[6,2,2,2,8,4]	],
	[	[6,2,2,2,2,2,4],
		[6,2,2,2,4,4],
		[6,2,2,2,4,4],
		[3,1,2,2,2,2,4,4]	],
	[	[6,2,2,2,2,2,4],
		[6,2,2,2,4,4],
		[6,2,2,2,2,1,1,4],   # corrected from organum
		[6,2,2,2,4,4]	],
	[	[3,1,2,2,4,4],
		[2,2,2,2,4,4],
		[2,2,2,2,2,2,4],
		[2,2,2,2,4,4]	]	]
},
{ p => [[	[3,2,8,2,7,1,7,1],				# class 3, card 4
		[1,7,5,6,5,5],
		[5,4,3,8,4,3,2,3],
		[1,2,3,4,5,1]	],
	[	[8,8,2,3,2,3],
		[6,5,4,2,5,5,5],
		[2,1,1,7,1,1,7,1],
		[4,3,2,1,5,1]	],
	[	[1,1,7,1,1,7,1],
		[6,6,5,4,5,5],
		[4,4,2,8,2,3],
		[4,4,5,6,5,1]	],
	[	[4,3,2,1,7,5,1,7,1],
		[6,6,6,6,5,5],
	#	[8,4,3,2,8,2,3,2,2],  # correcting last note to avoid ending on suspension
		[8,4,3,2,8,2,3,2,3],
		[4,4,5,6,5,1]	],
	[	[4,4,4,3,2,3],
		[6,6,6,5,5,5],
		[1,2,1,7,1,1,7,1],
		[4,4,5,1,5,1]	],
	[	[5,5,6,5,4,1,4,3,2,3],
		[1,2,1,7,6,5,4,5],
		[3,3,4,8,8,8],
		[8,8,4,3,4,1]	]	],
   r => [[	[6,2,3,1,1,2,1,4],
		[6,2,2,2,4,4],
		[6,2,2,1,2,1,2,4],
		[6,2,2,2,4,4]	],
	[	[2,2,2,2,4,4],
		[2,2,1,1,2,4,4],
		[2,2,1,1,2,2,2,4],
		[2,2,2,2,4,4]	],
	[	[6,2,2,2,2,2,4],
		[6,2,2,2,4,4],
		[6,2,2,2,4,4],
		[6,2,2,2,4,4]	],
	[	[2,2,2,2,1,1,4,2,4],
		[3,1,2,2,8,4],
		[4,2,2,2,1,1,2,2,4],
		[4,4,2,2,4,4]	],
	[	[6,2,2,2,4,4],
		[6,2,2,2,4,4],
		[6,1,1,2,2,2,2,4],
		[6,2,2,2,4,4]	],
	[	[6,2,2,2,1,1,4,1,1,4],
		[6,2,3,1,2,2,2,6],    # corrected to fit - need 2nd reference
		[6,2,2,2,8,4],
		[6,2,2,2,4,8]	]	]
}
] # end of cardlist
}, # end of cardset
# next card set
{
title => 'archilochica stylo (class IV)',
recommendedModes => [5,6,7,8],
meter => '4/4',
cards => [
	{ p => [[	[1,7,2,3,3,2,2,3],  # class 4 stropha 1
			[5,5,6,7,8,5,1,1,7,1],
			[3,2,4,5,5,5,5,5],
			[1,5,4,3,2,1,5,5,1]	],
		     [	[5,5,5,4,3,2,2,3],
			[8,7,8,8,8,8,7,8],
			[3,2,3,6,5,5,5,5],
			[1,5,3,4,1,5,5,1]	],
		     [	[3,3,3,2,3,2,1,1,7,1],
			[1,1,1,7,1,6,5,5],
			[5,5,5,5,5,4,3,2,1,2,3],
			[8,8,8,5,3,4,5,1]	],
		     [	[3,2,4,3,3,2,2,3],
			[8,7,2,1,1,1,7,1],
			[5,5,6,5,5,5,5,5],
			[1,5,2,3,4,5,5,1]	],
		     [	[3,4,3,4,5,5,4,5],
			[1,1,1,2,2,1,1,7],
			[5,6,5,2,2,3,2,8,2],
			[8,4,8,8,7,6,6,5]	],
		     [	[3,2,4,4,3,2,2,3],
			[7,1,1,2,1,1,7,1],
			[5,5,6,5,5,5,5,5],
			[5,8,6,7,8,5,5,1]	]
		     ], 
	 r => [[	[4,2,2,2,2,3,1,4],
			[4,2,1,-1,1,-1,2,2,-2,4],
			[4,2,2,2,2,3,1,4],
			[4,2,2,2,1,-1,3,1,4]],
		     [	[4,6,2,2,2,3,1,4],
			[4,6,2,2,2,2,2,4],
			[4,6,2,2,2,2,2,4],
			[4,6,2,2,2,3,1,4]],
		     [	[2,1,1,3,1,1,-1,4,-2,4],
			[2,1,1,3,1,4,4,4],
			[2,1,1,3,1,3,-1,1,-1,-2,4],
			[2,1,1,3,1,4,4,4]],
		     [	[4,2,2,2,2,3,1,4],
			[4,2,2,2,2,2,2,4],
			[4,2,2,2,2,2,2,4],
			[4,2,2,3,1,2,2,4]],
		     [	[4,2,2,2,2,2,2,4],
			[4,2,2,2,2,3,1,4],
			[4,2,2,2,2,2,1,-1,4],
			[4,2,2,2,2,2,2,4]],
		     [	[4,2,2,2,2,3,1,4],
			[4,2,2,2,2,3,1,4],
			[-2,2,2,2,2,2,2,2,4],
			[4,2,2,2,2,2,2,4]]
		     ]},
	{ p => [[	[3,3,5,5,4,5,6,6,5],  # class 4 stropha 2
			[8,8,2,8,7,2,2,7],
			[5,5,2,3,2,1,2,3,4,5,4,5],
			[1,1,7,6,5,2,2,5]],
		     [	[1,4,4,3,2,2,1,2],
			[6,6,6,6,5,6,6,6],
			[3,2,2,8,2,3,3,4],
			[6,4,2,6,7,6,6,2]],
		     [	[3,4,3,2,1,4,4,3,4],
			[8,8,7,6,8,8,8,8],
			[5,6,5,3,6,5,5,5],
			[8,4,5,6,4,1,1,4]],
		     [	[5,5,5,8,7,6,6,7],
			[3,3,2,3,6,2,2,2,2],
			[5,5,5,5,4,5,4,4,5],
			[8,8,7,6,5,2,2,5]],
		     [	[3,3,5,5,4,5,2,3,2,2,3],
			[8,8,2,8,7,6,5,6,5,7],
			[5,5,2,3,2,1,2,4,5,4,5],
			[1,1,7,6,5,4,3,2,1,2,2,5]],
		     [	[5,4,3,2,1,7,7,1],
			[8,7,6,5,6,7,5,5,5],
			[5,4,3,2,3,1,2,3,2,3,2,2,3],
			[8,7,6,5,6,7,5,6,5,4,3,4,5,5,1]]
		     ], 
	 r => [[	[4,3,1,2,-2,4,3,1,4],
			[4,3,1,4,4,3,1,4],
			[4,3,1,2,-1,-1,2,-1,-1,2,2,4],
			[4,3,1,4,4,3,1,4]],
		     [	[4,2,2,2,2,2,2,4],
			[4,2,2,3,1,2,2,4],
			[4,2,2,2,2,2,2,4],
			[4,2,2,2,2,2,2,4]],
		     [	[4,2,1,-1,2,2,2,2,4],
			[4,2,2,2,2,2,2,4],
			[4,2,2,2,2,2,2,4],
			[4,2,2,2,2,2,2,4]],
		     [	[4,3,1,2,2,3,1,4],
			[4,3,1,1,-1,2,3,1,4],
			[4,2,2,1,-1,2,3,1,4],
			[4,3,1,2,2,3,1,4]],
		     [	[4,3,1,2,-2,2,3,-1,1.5,-.5,4],
			[4,3,1,4,3,.5,-.5,3,-1,4],
			[4,3,1,2,-1,-1,4,1,2,-1,4],
			[4,3,1,4,3,.5,-.5,1,-1,-1,-1,4]],
		     [	[-8,1,.5,.5,1,1,1.5,.5,2],
			[-6,1,.5,-.5,1,1,1,2,1,2],
			[-1,1,1,-1,1,-1,1,-1,1,2,-1,1,-1,2],
			[1,-.5,-.5,1,-1,1,-1,1,-.5,-.5,1,-1,3,1,2]]
		     ]},
	{ p => [[	[2,3,5,5,4,5,2,2,3,2,2,2], # class 4 stropha 3
			[7,1,2,1,7,7,6,6,6,6,7],
			[5,5,2,3,2,1,2,5,4,5,4,4,5],
			[5,8,7,6,5,2,1,2,2,5]],
		     [	[7,1,2,1,7,7,6,6,6,6,7],
			[5,5,5,5,4,5,5,4,5,5,4,5],
			[2,3,2,3,2,1,2,2,2,3,2,2,2],
			[5,8,7,6,5,5,2,1,2,2,5]],
		     [	[3,2,7,1,7,6,7,1,7,6,7,1],
			[1,6,5,4,5,4,5,5,5,5],
			[5,4,2,1,3,1,3,2,2,3],
			[1,4,5,6,3,4,1,5,5,1]],
		     [	[4,3,2,1,2,2,3,4,3,4,3,4],
			[2,8,6,6,6,6,7,1,1,1,6,7,1,1,1],
			[6,5,4,3,4,4,5,6,5,4,5,5,6],
			[2,3,4,5,6,2,2,8,4,1,2,1,1,4]],
		     [	[3,4,3,2,3,3,3,2,1,1,7,1],
			[1,1,7,1,1,1,6,5,5,5,5],
			[5,6,5,5,5,5,4,3,2,2,3],
			[8,4,5,1,1,1,2,3,4,5,5,1]],
		     [	[2,3,3,2,1,1,1,7,1],
			[7,8,8,7,4,5,5,5],
			[5,5,5,4,3,2,8,3,2,3],
			[5,3,1,4,6,5,5,1]]
		     ], 
	 r => [[	[4,3,1,2,2,3,1,2,2,3,1,4],
			[4,3,1,4,3,1,2,2,3,1,4],
			[4,3,1,2,1,1,2,2,2,2,3,1,4],
			[4,3,1,4,4,2,2,3,1,4]],
		     [	[4,1,1,2,3,1,1,1,1.5,.5,4],
			[4,1,1,1,1,3,1,1,1,1.5,.5,4],
			[4,1,1,1,.5,.5,3,1,1,1,1.5,.5,4],
			[4,1,1,2,3,1,1,1,1.5,.5,4]],
		     [	[4,2,2,2,2,1,1,3,.5,.5,2,4],
			[4,2,3,1,2,2,2,3,1,4],
			[4,2,2,2,2,2,2,3,1,4],
			# [4,2,2,2,2,2,1,1,4,4]],  # corrected rhythm
			[4,2,2,1,2,2,2,2,3,4]],  # corrected rhythm based on extra note in melody
			                         # and vertical alignment of rhythm
		     [	[3,1,4,2,2,4,2,2,2,4,2,4],  # modified to fit - NEEDS WORK 
			[3,1,2,2,4,3,1,2,2,2,1,1,3,1,4],
			[3,1,2,2,4,4,2,2,2,2,3,1,4],
			[3,1,1,1,2,4,4,2,2,2,2,3,1,4]],
		     [	[2,1,-.5,-.5,2,1,-1,1,-1,1,1,4],
			[2,1,-1,2,1,-1,1,-1,1.5,.5,4],
			[2,1,-1,2,1,-1,1,-1,1,1,4],
			[2,1,-1,2,1,-1,1,-.5,-.5,1,1,4]],
		     [	[2,1,1,.5,.5,-1,1.5,.5,4],
			[2,1,1,1,1,1,1,4],
			[2,1,1,.5,.5,.5,.5,1,1,4],
			[2,1,1,1,1,1,1,4]]
		     ]},
	{  p => [[	[7,7,7,1,2,3,4,5,5,5], # class 4 stropha 4
			[5,5,5,6,8,8,7,8],
			[3,3,3,3,8,3,2,3],
			[3,3,3,6,6,5,5,1]],

		     [	[1,1,2,1,7,3,3,3,2,2,2,3],
			[5,6,7,5,8,8,8,8,8,7,8],
			[3,4,4,3,5,5,5,6,5,5,5],
			[1,4,2,3,1,1,8,4,5,5,1]],
		     [	[7,2,8,7,8,6,8,7,6,7,8],
			[5,5,5,5,5,4,5,5,5],
			[3,2,3,2,3,8,3,2,2,3],
			[3,7,1,5,3,4,1,5,5,1]],
		     [	[5,6,5,3,5,4,3,2,8,7,8],
			[8,8,7,8,7,6,5,5,5,5],
			[3,4,2,8,8,8,7,3,2,3],
			[8,4,5,6,3,4,1,5,1]],
		     [	[3,2,7,8,7,6,7,8,7,8],
			[8,6,5,4,5,4,5,5,5,5],
			[5,4,2,8,3,8,3,2,2,3],
			[1,4,5,6,3,4,1,5,5,1]],
		     [	[7,1,2,2,3,1,7,1],
			[5,6,6,5,5,4,5,5],
			[2,6,6,7,8,8,2,3,2,3],
			[5,5,4,4,3,6,5,1]]
		     ], 
	 r => [[	[2,1,1,1,1,1,1,3,1,4],
			[2,1,1,2,2,2,2,4],
			[2,1,1,2,2,2,2,4],
			[2,1,1,2,2,2,2,4]],
		     [	[4,2,2,1,1,1,1,2,2,3,1,4],
			[4,2,2,2,1,1,2,2,2,2,4],
			[4,2,2,2,1,1,2,2,2,2,4],
			[4,2,2,2,1,1,2,2,2,2,4]],
		     [	[4,2,2,2,2,2,3,.5,.5,2,4],
			[4,2,2,2,2,2,2,4,4],
			[4,2,2,2,2,2,2,3,1,4],
			[4,2,2,2,2,2,2,2,2,4]],
		     [	[4,2,2,2,2,2,2,2,4,2,4],
			[4,2,2,3,1,2,2,6,2,4],
			[4,2,2,2,2,4,2,2,4,4],
			[4,2,2,2,2,2,2,8,4]],
		     [	[2,1,1,1.5,.5,.5,.5,2,1,2],
			[2,1,1.5,.5,1,1,1,1.5,.5,2],
			[2,1,1,1,1,1,1,1.5,.5,2],
			[2,1,1,1,1,1,1,1,1,2]],
		     [	[4,2,2,2,2,6,2,4],
			[4,2,2,2,4,2,4,4],
			[4,2,2,2,2,3,-1,-2,2,4],
			[4,2,2,2,2,4,4,4]]
		     ]}
	] # end of card

}  # end of cardset

]; # end of cardset array

return 1;
